

CREATE TABLE `apps` (
  `id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `url` varchar(500) DEFAULT NULL,
  `info` text NOT NULL,
  `apk` varchar(500) DEFAULT NULL,
  `imagens` text DEFAULT NULL,
  `criado_em` timestamp NULL DEFAULT current_timestamp(),
  `arquivo` varchar(255) DEFAULT NULL,
  `codigo` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `apps`
--

INSERT INTO `apps` (`id`, `nome`, `url`, `info`, `apk`, `imagens`, `criado_em`, `arquivo`, `codigo`) VALUES
(24, 'Streambox v5.0', '', 'Lançamento do recurso Meerkat do Android Studio | 2024.3.2\r\nAtualizar dependências\r\nAtualizar UI/UX\r\nMedia3 ExoPlayer 1.6.1\r\nAtualização da biblioteca\r\nPequenos bugs corrigidos\r\nIsto é importante para atualizações futuras.', 'STREAMBOX_V5_0.apk', 'STREAMBOX_V5_0.png', '2025-06-16 15:57:06', NULL, 2024);

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `usuario` varchar(50) NOT NULL,
  `senha_hash` varchar(255) NOT NULL,
  `nivel_acesso` enum('admin','editor') DEFAULT 'editor',
  `criado_em` datetime DEFAULT current_timestamp(),
  `ultimo_login` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `usuarios`
--

INSERT INTO `usuarios` (`id`, `usuario`, `senha_hash`, `nivel_acesso`, `criado_em`, `ultimo_login`) VALUES
(2, 'admin', '$2y$10$kr6hkSc3lAeAfIwrxx8NW.jaiO0zLb4icl4fq7i47DIrXR3C6oGAq', 'admin', '2025-06-01 15:35:30', '2025-06-16 15:55:37');

--
-- Índices para tabelas despejadas
--

--
-- Índices de tabela `apps`
--
ALTER TABLE `apps`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `codigo` (`codigo`);

--
-- Índices de tabela `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `usuario` (`usuario`);

--
-- AUTO_INCREMENT para tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `apps`
--
ALTER TABLE `apps`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT de tabela `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
